
from gurobipy import *

# Create a new model
m = Model("Vitamin_Optimization")

# Define variables
x1 = m.addVar(name="milligrams_of_vitamin_B5", lb=0, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS)
x2 = m.addVar(name="milligrams_of_vitamin_B12", lb=0, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS)

# Set the objective function
m.setObjective(5*x1 + 5*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(3*x1 + 32*x2 >= 32, name="min_cardiovascular_support")
m.addConstr(11*x1 + 10*x2 >= 36, name="min_cognitive_performance")
m.addConstr(6*x1 + 8*x2 >= 28, name="min_digestive_support")
m.addConstr(-10*x1 + 9*x2 >= 0, name="vitamin_combination_constraint")
m.addConstr(3*x1 + 32*x2 <= 44, name="max_cardiovascular_support")
m.addConstr(11*x1 + 10*x2 <= 88, name="max_cognitive_performance")
m.addConstr(6*x1 + 8*x2 <= 86, name="max_digestive_support")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Milligrams of Vitamin B5: {x1.x}")
    print(f"Milligrams of Vitamin B12: {x2.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
