
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="x1", lb=0)  # milligrams of vitamin B5
    x2 = model.addVar(name="x2", lb=0)  # milligrams of vitamin B12

    # Define the objective function
    model.setObjective(5 * x1 + 5 * x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(3 * x1 + 32 * x2 >= 32)
    model.addConstr(11 * x1 + 10 * x2 >= 36)
    model.addConstr(6 * x1 + 8 * x2 >= 28)
    model.addConstr(-10 * x1 + 9 * x2 >= 0)
    model.addConstr(3 * x1 + 32 * x2 <= 44)
    model.addConstr(11 * x1 + 10 * x2 <= 88)
    model.addConstr(6 * x1 + 8 * x2 <= 86)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin B5: {x1.varValue}")
        print(f"Milligrams of vitamin B12: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
