
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    laura = model.addVar(vtype=gp.GRB.INTEGER, name="laura")
    george = model.addVar(vtype=gp.GRB.INTEGER, name="george")
    dale = model.addVar(vtype=gp.GRB.CONTINUOUS, name="dale")
    paul = model.addVar(vtype=gp.GRB.INTEGER, name="paul")


    # Set objective function
    model.setObjective(1.55 * laura + 3.23 * george + 9.61 * dale + 1.91 * paul, gp.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(13 * laura + 10 * dale >= 26, "c0")
    model.addConstr(5 * george + 11 * paul <= 76, "c1")
    model.addConstr(10 * dale + 11 * paul <= 57, "c2")
    model.addConstr(13 * laura + 5 * george <= 104, "c3")
    model.addConstr(5 * george + 10 * dale <= 94, "c4")
    model.addConstr(13 * laura + 10 * dale <= 38, "c5")
    model.addConstr(13 * laura + 5 * george + 10 * dale + 11 * paul <= 38, "c6")


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
    elif model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {model.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
