
import gurobi as gp

# Define the model
m = gp.Model()

# Define the variables
x1 = m.addVar(name="hours_worked_by_Laura", vtype=gp.GRB.INTEGER)  # Laura
x2 = m.addVar(name="hours_worked_by_George", vtype=gp.GRB.INTEGER)  # George
x3 = m.addVar(name="hours_worked_by_Dale")  # Dale
x4 = m.addVar(name="hours_worked_by_Paul", vtype=gp.GRB.INTEGER)  # Paul

# Define the objective function
m.setObjective(1.55 * x1 + 3.23 * x2 + 9.61 * x3 + 1.91 * x4, gp.GRB.MAXIMIZE)

# Define the constraints
m.addConstr(13 * x1 + 10 * x3 >= 26)
m.addConstr(5 * x2 + 11 * x4 <= 76)
m.addConstr(10 * x3 + 11 * x4 <= 57)
m.addConstr(13 * x1 + 5 * x2 <= 104)
m.addConstr(5 * x2 + 10 * x3 <= 94)
m.addConstr(13 * x1 + 10 * x3 <= 38)
m.addConstr(13 * x1 + 5 * x2 + 10 * x3 + 11 * x4 <= 38)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Hours worked by Laura: {x1.varValue}")
    print(f"Hours worked by George: {x2.varValue}")
    print(f"Hours worked by Dale: {x3.varValue}")
    print(f"Hours worked by Paul: {x4.varValue}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
