
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_model")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x0")  # hours worked by Jean
    x1 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x1")  # hours worked by Dale
    x2 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x2")  # hours worked by Ringo
    x3 = m.addVar(vtype=gp.GRB.INTEGER, name="x3")  # hours worked by George


    # Set objective function
    m.setObjective(5*x0 + 1*x1 + 3*x2 + 2*x3, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(7*x0 + 4*x2 >= 14)
    m.addConstr(4*x2 + 2*x3 >= 26)
    m.addConstr(2*x1 + 4*x2 >= 25)
    m.addConstr(7*x0 + 2*x1 >= 14)
    m.addConstr(7*x0 + 2*x3 >= 13)
    m.addConstr(10*x1 + 4*x3 >= 47)
    m.addConstr(10*x1 + 4*x2 >= 33)
    m.addConstr(7*x0 + 10*x1 + 4*x3 >= 34)
    m.addConstr(7*x0 + 4*x2 + 4*x3 >= 34)
    m.addConstr(7*x0 + 10*x1 + 4*x2 >= 34)
    m.addConstr(10*x1 + 4*x2 + 4*x3 >= 34)
    m.addConstr(7*x0 + 10*x1 + 4*x3 >= 47)
    m.addConstr(7*x0 + 4*x2 + 4*x3 >= 47)
    m.addConstr(7*x0 + 10*x1 + 4*x2 >= 47)
    m.addConstr(10*x1 + 4*x2 + 4*x3 >= 47)
    m.addConstr(7*x0 + 10*x1 + 4*x3 >= 54)
    m.addConstr(7*x0 + 4*x2 + 4*x3 >= 54)
    m.addConstr(7*x0 + 10*x1 + 4*x2 >= 54)
    m.addConstr(10*x1 + 4*x2 + 4*x3 >= 54)
    m.addConstr(1*x1 + 10*x2 <= 33)
    m.addConstr(9*x0 + 1*x1 <= 110)
    m.addConstr(10*x2 + 3*x3 <= 115)
    m.addConstr(9*x0 + 10*x2 <= 31)
    m.addConstr(9*x0 + 1*x1 + 10*x2 + 3*x3 <= 31)
    m.addConstr(4*x2 + 2*x3 <= 55)
    m.addConstr(2*x1 + 4*x2 + 2*x3 <= 69)
    m.addConstr(7*x0 + 2*x1 + 4*x2 <= 87)
    m.addConstr(7*x0 + 2*x1 + 2*x3 <= 92)
    m.addConstr(7*x0 + 4*x2 + 2*x3 <= 87)
    m.addConstr(7*x0 + 2*x1 + 4*x2 + 2*x3 <= 87)
    m.addConstr(4*x2 + 4*x3 <= 131)
    m.addConstr(10*x1 + 4*x3 <= 76)
    m.addConstr(10*x1 + 4*x2 <= 103)
    m.addConstr(7*x0 + 10*x1 + 4*x2 + 4*x3 <= 103)



    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Model is infeasible')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
