
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name='x0', lb=0)  # hours worked by Jean
x1 = m.addVar(name='x1', lb=0)  # hours worked by Dale
x2 = m.addVar(name='x2', lb=0)  # hours worked by Ringo
x3 = m.addVar(name='x3', lb=0, integrality=1)  # hours worked by George

# Objective function
m.setObjective(5*x0 + x1 + 3*x2 + 2*x3, gurobi.GRB.MAXIMIZE)

# Constraints
m.addConstr(9*x0 <= 116)
m.addConstr(7*x0 <= 104)
m.addConstr(7*x0 <= 223)
m.addConstr(1*x1 <= 116)
m.addConstr(2*x1 <= 104)
m.addConstr(10*x1 <= 223)
m.addConstr(10*x2 <= 116)
m.addConstr(4*x2 <= 104)
m.addConstr(4*x2 <= 223)
m.addConstr(3*x3 <= 116)
m.addConstr(2*x3 <= 104)
m.addConstr(4*x3 <= 223)
m.addConstr(7*x0 + 4*x2 >= 14)
m.addConstr(4*x2 + 2*x3 >= 26)
m.addConstr(2*x1 + 4*x2 >= 25)
m.addConstr(7*x0 + 2*x1 >= 14)
m.addConstr(7*x0 + 2*x3 >= 13)
m.addConstr(10*x1 + 4*x3 >= 47)
m.addConstr(10*x1 + 4*x2 >= 33)
m.addConstr(7*x0 + 10*x1 + 4*x3 >= 29)
m.addConstr(7*x0 + 4*x2 + 4*x3 >= 29)
m.addConstr(7*x0 + 10*x1 + 4*x2 >= 29)
m.addConstr(10*x1 + 4*x2 + 4*x3 >= 29)
m.addConstr(7*x0 + 10*x1 + 4*x3 >= 34)
m.addConstr(7*x0 + 4*x2 + 4*x3 >= 34)
m.addConstr(7*x0 + 10*x1 + 4*x2 >= 34)
m.addConstr(10*x1 + 4*x2 + 4*x3 >= 34)
m.addConstr(7*x0 + 10*x1 + 4*x3 >= 47)
m.addConstr(7*x0 + 4*x2 + 4*x3 >= 47)
m.addConstr(7*x0 + 10*x1 + 4*x2 >= 47)
m.addConstr(10*x1 + 4*x2 + 4*x3 >= 47)
m.addConstr(7*x0 + 10*x1 + 4*x3 >= 54)
m.addConstr(7*x0 + 4*x2 + 4*x3 >= 54)
m.addConstr(7*x0 + 10*x1 + 4*x2 >= 54)
m.addConstr(10*x1 + 4*x2 + 4*x3 >= 54)
m.addConstr(1*x1 + 10*x2 <= 33)
m.addConstr(9*x0 + 1*x1 <= 110)
m.addConstr(10*x2 + 3*x3 <= 115)
m.addConstr(9*x0 + 10*x2 <= 31)
m.addConstr(9*x0 + 1*x1 + 10*x2 + 3*x3 <= 31)
m.addConstr(4*x2 + 2*x3 <= 55)
m.addConstr(2*x1 + 4*x2 + 2*x3 <= 69)
m.addConstr(7*x0 + 2*x1 + 4*x2 <= 87)
m.addConstr(7*x0 + 2*x1 + 2*x3 <= 92)
m.addConstr(7*x0 + 4*x2 + 2*x3 <= 87)
m.addConstr(7*x0 + 2*x1 + 4*x2 + 2*x3 <= 87)
m.addConstr(4*x2 + 4*x3 <= 131)
m.addConstr(10*x1 + 4*x3 <= 76)
m.addConstr(10*x1 + 4*x2 <= 103)
m.addConstr(7*x0 + 10*x1 + 4*x2 + 4*x3 <= 103)

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print('Objective: ', m.objVal)
    print('x0: ', x0.varValue)
    print('x1: ', x1.varValue)
    print('x2: ', x2.varValue)
    print('x3: ', x3.varValue)
else:
    print('No solution found')
