
import gurobipy as gp

# Create a new model
m = gp.Model("nutrition_optimization")

# Create variables
vitamin_b4 = m.addVar(lb=0, name="vitamin_b4")
protein = m.addVar(lb=0, name="protein")
calcium = m.addVar(lb=0, name="calcium")
vitamin_b6 = m.addVar(lb=0, name="vitamin_b6")


# Set objective function
m.setObjective(8 * vitamin_b4 + 6 * protein + 1 * calcium + 4 * vitamin_b6, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(11 * vitamin_b4 + 12 * protein + 8 * calcium + 1 * vitamin_b6 <= 152, "r0")
m.addConstr(21 * vitamin_b4 + 1 * protein + 2 * calcium + 13 * vitamin_b6 <= 201, "r1")
m.addConstr(14 * vitamin_b4 + 10 * protein + 12 * calcium + 19 * vitamin_b6 <= 160, "r2")
m.addConstr(11 * vitamin_b4 + 1 * vitamin_b6 >= 32, "c1")
m.addConstr(12 * calcium + 19 * vitamin_b6 >= 37, "c2")
m.addConstr(14 * vitamin_b4 + 10 * protein + 19 * vitamin_b6 >= 25, "c3")
m.addConstr(14 * vitamin_b4 + 10 * protein + 12 * calcium >= 25, "c4")
m.addConstr(8 * calcium + 1 * vitamin_b6 <= 76, "c5")
m.addConstr(12 * protein + 1 * vitamin_b6 <= 95, "c6")
m.addConstr(11 * vitamin_b4 + 8 * calcium <= 133, "c7")
m.addConstr(11 * vitamin_b4 + 12 * protein + 8 * calcium + 1 * vitamin_b6 <= 133, "c8")
m.addConstr(1 * protein + 13 * vitamin_b6 <= 104, "c9")
m.addConstr(21 * vitamin_b4 + 1 * protein <= 63, "c10")
m.addConstr(2 * calcium + 13 * vitamin_b6 <= 139, "c11")
m.addConstr(21 * vitamin_b4 + 13 * vitamin_b6 <= 181, "c12")
m.addConstr(21 * vitamin_b4 + 1 * protein + 2 * calcium <= 141, "c13")
m.addConstr(21 * vitamin_b4 + 1 * protein + 13 * vitamin_b6 <= 176, "c14")
m.addConstr(21 * vitamin_b4 + 2 * calcium + 13 * vitamin_b6 <= 134, "c15")
m.addConstr(21 * vitamin_b4 + 1 * protein + 2 * calcium + 13 * vitamin_b6 <= 134, "c16")
m.addConstr(14 * vitamin_b4 + 10 * protein <= 131, "c17")
m.addConstr(12 * calcium + 19 * vitamin_b6 <= 149, "c18")
m.addConstr(10 * protein + 12 * calcium <= 136, "c19")
m.addConstr(14 * vitamin_b4 + 10 * protein + 12 * calcium + 19 * vitamin_b6 <= 136, "c20")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

