
import gurobi as gp

# Define the model
m = gp.Model("optimization_problem")

# Define the variables
x1 = m.addVar(name="milligrams_of_vitamin_B4", lb=0)
x2 = m.addVar(name="grams_of_protein", lb=0)
x3 = m.addVar(name="milligrams_of_calcium", lb=0)
x4 = m.addVar(name="milligrams_of_vitamin_B6", lb=0)

# Define the objective function
m.setObjective(8*x1 + 6*x2 + x3 + 4*x4, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(11*x1 <= 152)
m.addConstr(21*x1 <= 201)
m.addConstr(14*x1 <= 160)
m.addConstr(12*x2 <= 152)
m.addConstr(x2 <= 201)
m.addConstr(10*x2 <= 160)
m.addConstr(8*x3 <= 152)
m.addConstr(2*x3 <= 201)
m.addConstr(12*x3 <= 160)
m.addConstr(x4 <= 152)
m.addConstr(13*x4 <= 201)
m.addConstr(19*x4 <= 160)

m.addConstr(11*x1 + x4 >= 32)
m.addConstr(12*x3 + 19*x4 >= 37)
m.addConstr(14*x1 + 10*x2 + 19*x4 >= 25)
m.addConstr(14*x1 + 10*x2 + 12*x3 >= 25)

m.addConstr(8*x3 + x4 <= 76)
m.addConstr(12*x2 + x4 <= 95)
m.addConstr(11*x1 + 8*x3 <= 133)
m.addConstr(11*x1 + 12*x2 + 8*x3 + x4 <= 133)

m.addConstr(x2 + 13*x4 <= 104)
m.addConstr(21*x1 + x2 <= 63)
m.addConstr(2*x3 + 13*x4 <= 139)
m.addConstr(21*x1 + 13*x4 <= 181)
m.addConstr(21*x1 + x2 + 2*x3 <= 141)
m.addConstr(21*x1 + x2 + 13*x4 <= 176)
m.addConstr(21*x1 + 2*x3 + 13*x4 <= 134)
m.addConstr(21*x1 + x2 + 2*x3 + 13*x4 <= 134)

m.addConstr(14*x1 + 10*x2 <= 131)
m.addConstr(12*x3 + 19*x4 <= 149)
m.addConstr(10*x2 + 12*x3 <= 136)
m.addConstr(14*x1 + 10*x2 + 12*x3 + 19*x4 <= 136)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Milligrams of vitamin B4: ", x1.varValue)
    print("Grams of protein: ", x2.varValue)
    print("Milligrams of calcium: ", x3.varValue)
    print("Milligrams of vitamin B6: ", x4.varValue)
else:
    print("The model is infeasible")
