
import gurobipy as gp

# Create a new model
m = gp.Model("resource_allocation")

# Create variables
x0 = m.addVar(vtype=gp.GRB.INTEGER, name="air_defense_batteries")
x1 = m.addVar(vtype=gp.GRB.INTEGER, name="CBRN_platoons")
x2 = m.addVar(vtype=gp.GRB.INTEGER, name="armored_companies")


# Set objective function
m.setObjective(2*x0**2 + 7*x1 + 3*x2**2, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(13.82*x0**2 + 18.43*x2**2 >= 58)
m.addConstr(11.71*x0**2 + 5.43*x2**2 >= 12)
m.addConstr(9.6*x1 + 5.43*x2 >= 35)
m.addConstr(28.74*x1**2 + 20.84*x2**2 >= 64)
m.addConstr(13.82*x0**2 + 0.07*x1**2 <= 144)
m.addConstr(0.07*x1 + 18.43*x2 <= 65)
m.addConstr(13.82*x0**2 + 18.43*x2**2 <= 119)
m.addConstr(13.82*x0 + 0.07*x1 + 18.43*x2 <= 119)
m.addConstr(11.71*x0 + 5.43*x2 <= 45)
m.addConstr(11.71*x0 + 9.6*x1 <= 77)
m.addConstr(11.71*x0**2 + 9.6*x1**2 + 5.43*x2**2 <= 90)
m.addConstr(11.71*x0 + 9.6*x1 + 5.43*x2 <= 90)
m.addConstr(12.86*x0**2 + 28.74*x1**2 <= 198)
m.addConstr(28.74*x1 + 20.84*x2 <= 240)
m.addConstr(12.86*x0 + 28.74*x1 + 20.84*x2 <= 240)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

