
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x1 = m.addVar(name="air_defense_batteries", vtype=gurobi.GRB.INTEGER)
x2 = m.addVar(name="CBRN_platoons", vtype=gurobi.GRB.INTEGER)
x3 = m.addVar(name="armored_companies", vtype=gurobi.GRB.INTEGER)

# Objective function
m.setObjective(2*x1**2 + 7*x2 + 3*x3**2, gurobi.GRB.MAXIMIZE)

# Constraints
m.addConstr(13.82*x1 <= 192)
m.addConstr(11.71*x1 <= 111)
m.addConstr(12.86*x1 <= 243)
m.addConstr(0.07*x2 <= 192)
m.addConstr(9.6*x2 <= 111)
m.addConstr(28.74*x2 <= 243)
m.addConstr(18.43*x3 <= 192)
m.addConstr(5.43*x3 <= 111)
m.addConstr(20.84*x3 <= 243)
m.addConstr(13.82*x1**2 + 18.43*x3**2 >= 58)
m.addConstr(11.71*x1**2 + 5.43*x3**2 >= 12)
m.addConstr(9.6*x2 + 5.43*x3 >= 35)
m.addConstr(28.74*x2**2 + 20.84*x3**2 >= 64)
m.addConstr(13.82*x1**2 + 0.07*x2**2 <= 144)
m.addConstr(0.07*x2 + 18.43*x3 <= 65)
m.addConstr(13.82*x1**2 + 18.43*x3**2 <= 119)
m.addConstr(13.82*x1 + 0.07*x2 + 18.43*x3 <= 119)
m.addConstr(11.71*x1 + 5.43*x3 <= 45)
m.addConstr(11.71*x1 + 9.6*x2 <= 77)
m.addConstr(11.71*x1**2 + 9.6*x2**2 + 5.43*x3**2 <= 90)
m.addConstr(11.71*x1 + 9.6*x2 + 5.43*x3 <= 90)
m.addConstr(12.86*x1**2 + 28.74*x2**2 <= 198)
m.addConstr(28.74*x2 + 20.84*x3 <= 240)
m.addConstr(12.86*x1 + 28.74*x2 + 20.84*x3 <= 240)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Air defense batteries: ", x1.varValue)
    print("CBRN platoons: ", x2.varValue)
    print("Armored companies: ", x3.varValue)
else:
    print("The model is infeasible")
