
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
foods = ['eggs', 'cheeseburgers', 'bowls of pasta', 'bowls of cereal', 'strawberries', 'chicken drumsticks']
x = m.addVars(foods, lb=0.0, name="x")


# Set objective function
m.setObjective(4*x['eggs'] + 2*x['cheeseburgers'] + 5*x['bowls of pasta'] + 1*x['bowls of cereal'] + 5*x['strawberries'] + 5*x['chicken drumsticks'], gp.GRB.MINIMIZE)

# Resource data
resources = {
    'r0': {'description': 'tastiness rating', 'upper_bound': 374, 'eggs': 19, 'cheeseburgers': 18, 'bowls of pasta': 24, 'bowls of cereal': 11, 'strawberries': 29, 'chicken drumsticks': 28},
    'r1': {'description': 'milligrams of calcium', 'upper_bound': 280, 'eggs': 7, 'cheeseburgers': 23, 'bowls of pasta': 21, 'bowls of cereal': 10, 'strawberries': 5, 'chicken drumsticks': 7},
    'r2': {'description': 'milligrams of iron', 'upper_bound': 380, 'eggs': 26, 'cheeseburgers': 16, 'bowls of pasta': 16, 'bowls of cereal': 2, 'strawberries': 2, 'chicken drumsticks': 18}
}

# Add resource constraints
for r, data in resources.items():
    m.addConstr(gp.quicksum(data[food] * x[food] for food in foods) <= data['upper_bound'], name=r)


# Add other constraints from the problem description
m.addConstr(24*x['bowls of pasta'] + 29*x['strawberries'] >= 28)
m.addConstr(19*x['eggs'] + 29*x['strawberries'] >= 20)
# ... (add all other constraints similarly)

# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Optimal objective value:', m.objVal)
    for food in foods:
        print(f'{food}: {x[food].x}')
elif m.status == gp.GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print('Optimization ended with status:', m.status)

