
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(name="hamburgers", vtype=gp.GRB.INTEGER)  # hamburgers
x1 = m.addVar(name="knishes", vtype=gp.GRB.INTEGER)    # knishes
x2 = m.addVar(name="oranges")                           # oranges
x3 = m.addVar(name="oreos", vtype=gp.GRB.INTEGER)       # oreos

# Objective function to maximize
m.setObjective(4*x0 + 7*x1 + 8*x2 + x3, gp.GRB.MAXIMIZE)

# Constraints
m.addConstr(7*x0 + 4*x1 + 6*x2 + 4*x3 <= 116)  # dollar cost
m.addConstr(8*x0 + 11*x1 + 3*x2 + 6*x3 <= 165)  # milligrams of calcium
m.addConstr(6*x2 + 4*x3 >= 20)  # spend at least 20 dollars on oranges plus oreos
m.addConstr(4*x1 + 6*x2 >= 25)  # spend at least $25 on knishes and oranges
m.addConstr(7*x0 + 4*x3 >= 20)  # spend at least 20 dollars on hamburgers plus oreos
m.addConstr(7*x0 + 4*x1 + 4*x3 >= 20)  # spend at least $20 on hamburgers plus knishes plus oreos
m.addConstr(11*x1 + 6*x3 >= 24)  # at least 24 milligrams of calcium from knishes and oreos
m.addConstr(4*x1 + 6*x2 <= 77)  # spend no more than $77 on knishes and oranges
m.addConstr(6*x2 + 4*x3 <= 79)  # spend no more than 79 dollars on oranges plus oreos
m.addConstr(7*x0 + 4*x1 + 6*x2 + 4*x3 <= 116)  # total cost at most $116
m.addConstr(8*x0 + 11*x1 <= 122)  # no more than 122 milligrams of calcium from hamburgers and knishes
m.addConstr(11*x1 + 3*x2 <= 97)  # no more than 97 milligrams of calcium from knishes and oranges
m.addConstr(8*x0 + 11*x1 + 6*x3 <= 125)  # at most 125 milligrams of calcium from hamburgers, knishes, and oreos
m.addConstr(8*x0 + 11*x1 + 3*x2 + 6*x3 <= 125)  # at most 125 milligrams of calcium from all

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("hamburgers: ", x0.varValue)
    print("knishes: ", x1.varValue)
    print("oranges: ", x2.varValue)
    print("oreos: ", x3.varValue)
else:
    print("The model is infeasible")
