
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("food_optimization")

    # Create variables
    knishes = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="knishes")
    ramen = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="ramen")
    pickles = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="pickles")

    # Set objective function
    m.setObjective(5*knishes + 2*ramen + 8*pickles, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(9*knishes + 4*ramen + 7*pickles <= 121, "fiber_limit")
    m.addConstr(3*knishes + 8*ramen + 4*pickles <= 107, "iron_limit")
    m.addConstr(4*ramen + 7*pickles >= 32, "fiber_ramen_pickles")
    m.addConstr(9*knishes + 4*ramen >= 21, "fiber_knishes_ramen")
    m.addConstr(9*knishes + 4*ramen + 7*pickles >= 21, "fiber_total")
    m.addConstr(3*knishes + 8*ramen >= 27, "iron_knishes_ramen")
    m.addConstr(8*ramen + 4*pickles >= 25, "iron_ramen_pickles")
    m.addConstr(3*knishes + 4*pickles >= 33, "iron_knishes_pickles")
    m.addConstr(3*knishes + 8*ramen + 4*pickles >= 33, "iron_total")
    m.addConstr(knishes - 10*ramen >= 0, "knishes_vs_ramen")
    m.addConstr(8*ramen - 2*pickles >= 0, "ramen_vs_pickles")
    m.addConstr(8*ramen + 4*pickles <= 54, "iron_ramen_pickles_upper")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('knishes:', knishes.x)
        print('ramen:', ramen.x)
        print('pickles:', pickles.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
