
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    knishes = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="knishes")
    bowls_of_instant_ramen = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="bowls_of_instant_ramen")
    pickles = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="pickles")

    # Define the objective function
    model.setObjective(5 * knishes + 2 * bowls_of_instant_ramen + 8 * pickles, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(4 * bowls_of_instant_ramen + 7 * pickles >= 32, name="fiber_from_ramen_and_pickles")
    model.addConstr(9 * knishes + 4 * bowls_of_instant_ramen >= 21, name="fiber_from_knishes_and_ramen")
    model.addConstr(9 * knishes + 4 * bowls_of_instant_ramen + 7 * pickles >= 21, name="total_fiber")
    model.addConstr(3 * knishes + 8 * bowls_of_instant_ramen >= 27, name="iron_from_knishes_and_ramen")
    model.addConstr(8 * bowls_of_instant_ramen + 4 * pickles >= 25, name="iron_from_ramen_and_pickles")
    model.addConstr(3 * knishes + 4 * pickles >= 33, name="iron_from_knishes_and_pickles")
    model.addConstr(3 * knishes + 8 * bowls_of_instant_ramen + 4 * pickles >= 33, name="total_iron")
    model.addConstr(knishes - 10 * bowls_of_instant_ramen >= 0, name="knishes_vs_ramen")
    model.addConstr(8 * bowls_of_instant_ramen - 2 * pickles >= 0, name="ramen_vs_pickles")
    model.addConstr(8 * bowls_of_instant_ramen + 4 * pickles <= 54, name="iron_limit")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("Knishes: ", knishes.x)
        print("Bowls of instant ramen: ", bowls_of_instant_ramen.x)
        print("Pickles: ", pickles.x)
    else:
        print("Model is infeasible")

solve_optimization_problem()
