
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
pasta = m.addVar(vtype=gp.GRB.INTEGER, name="pasta")
cantaloupe = m.addVar(vtype=gp.GRB.CONTINUOUS, name="cantaloupe")
cereal = m.addVar(vtype=gp.GRB.CONTINUOUS, name="cereal")
apples = m.addVar(vtype=gp.GRB.INTEGER, name="apples")
kale = m.addVar(vtype=gp.GRB.INTEGER, name="kale")


# Set objective function
m.setObjective(4.53*pasta**2 + 9.81*pasta*cantaloupe + 2.29*pasta*cereal + 8.81*pasta*apples + 4.72*pasta*kale + 8.46*cantaloupe**2 + 7.24*cantaloupe*cereal + 6.79*cantaloupe*apples + 1.09*cantaloupe*kale + 1.84*apples**2 + 3.77*apples*kale + 9.4*kale**2 + 9.68*pasta + 4.89*cantaloupe + 7.66*cereal + 4.29*apples, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(7*pasta + 14*cantaloupe + 1*cereal + 10*apples + 5*kale <= 172, "r0")
m.addConstr(7*pasta + 13*cantaloupe + 9*cereal + 3*apples + 5*kale <= 86, "r1")
m.addConstr(12*pasta + 6*cantaloupe + 13*cereal + 7*apples + 3*kale <= 243, "r2")
# ... (rest of the constraints from the JSON "constraints" field)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print('Optimization problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

