
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
x1 = m.addVar(name="chives", vtype=gp.GRB.INTEGER)
x2 = m.addVar(name="basil_plants", vtype=gp.GRB.INTEGER)

# Define the objective function
m.setObjective(7*x1 + 7*x2, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(0.15*x1 + 0.99*x2 >= 33, name="water_need")
m.addConstr(0.95*x1 + 0.06*x2 >= 50, name="beauty_rating")
m.addConstr(0.17*x1 + 0.6*x2 >= 27, name="planting_space")
m.addConstr(0.44*x1 + 0.75*x2 >= 25, name="resilience_index")
m.addConstr(5*x1 - 9*x2 >= 0, name="additional_constraint")
m.addConstr(0.15*x1 + 0.99*x2 <= 112, name="max_water")
m.addConstr(0.95*x1 + 0.06*x2 <= 77, name="max_beauty")
m.addConstr(0.17*x1 + 0.6*x2 <= 123, name="max_planting_space")
m.addConstr(0.44*x1 + 0.75*x2 <= 105, name="max_resilience")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Chives: {x1.varValue}")
    print(f"Basil Plants: {x2.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("No optimal solution found.")
