
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x0") # milligrams of vitamin E
    x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="x1") # milligrams of potassium


    # Set objective function
    m.setObjective(9.93*x0**2 + 8.38*x0*x1 + 3.08*x1**2 + 6.29*x1, GRB.MINIMIZE)

    # Add constraints
    m.addConstr(14*x0 + 17*x1 >= 66, "c0")
    m.addConstr(12*x0 + 14*x1 >= 21, "c1")
    m.addConstr(4*x0 + 14*x1 >= 8, "c2")
    m.addConstr(17*x0 + 1*x1 >= 19, "c3")
    m.addConstr(-10*x0**2 + 1*x1**2 >= 0, "c4")
    m.addConstr(14*x0 + 17*x1 <= 127, "c5")
    m.addConstr(12*x0 + 14*x1 <= 36, "c6")
    m.addConstr(4*x0 + 14*x1 <= 37, "c7")
    m.addConstr(17*x0 + 1*x1 <= 74, "c8")


    # Optimize model
    m.optimize()

    if m.status == GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('x0: %g' % x0.x)
        print('x1: %g' % x1.x)
    elif m.status == GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
