
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(name="x0", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
    x1 = model.addVar(name="x1", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)

    # Objective function
    model.setObjective(9.93 * x0**2 + 8.38 * x0 * x1 + 3.08 * x1**2 + 6.29 * x1, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(14 * x0 <= 134)
    model.addConstr(12 * x0 <= 56)
    model.addConstr(4 * x0 <= 40)
    model.addConstr(17 * x0 <= 105)
    model.addConstr(17 * x1 <= 134)
    model.addConstr(14 * x1 <= 56)
    model.addConstr(14 * x1 <= 40)
    model.addConstr(x1 <= 105)
    model.addConstr(14 * x0 + 17 * x1 >= 66)
    model.addConstr(12 * x0 + 14 * x1 >= 21)
    model.addConstr(4 * x0 + 14 * x1 >= 8)
    model.addConstr(17 * x0**2 + x1**2 >= 19)
    model.addConstr(-10 * x0**2 + x1**2 >= 0)
    model.addConstr((14 * x0)**2 + (17 * x1)**2 <= 127**2)
    model.addConstr(12 * x0 + 14 * x1 <= 36)
    model.addConstr(4 * x0 + 14 * x1 <= 37)
    model.addConstr(17 * x0 + x1 <= 74)

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"x0: {x0.varValue}")
        print(f"x1: {x1.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
