
from gurobipy import *

# Create a new model
m = Model("Hours_Worked")

# Define variables (hours worked by each person)
x1 = m.addVar(name="Peggy", vtype=GRB.INTEGER)  # Peggy must work integer hours
x2 = m.addVar(name="Paul", vtype=GRB.INTEGER)   # Paul must work integer hours
x3 = m.addVar(name="George")                    # George can work non-integer hours
x4 = m.addVar(name="Mary")                      # Mary can work fractional hours
x5 = m.addVar(name="Ringo", vtype=GRB.INTEGER)  # Ringo must work whole number hours
x6 = m.addVar(name="Dale")                      # Dale can work non-whole number hours
x7 = m.addVar(name="Jean")                      # Jean can work non-integer hours
x8 = m.addVar(name="John", vtype=GRB.INTEGER)   # John must work integer hours

# Example constraint: Total combined dollar cost per hour for Peggy and George is at most 151.
m.addConstr(x1 + x3 <= 151, name="Peggy_and_George_max")

# Add more constraints as needed...

# Since the objective function isn't defined, we'll just minimize a placeholder (sum of hours worked)
m.setObjective(x1 + x2 + x3 + x4 + x5 + x6 + x7 + x8, GRB.MINIMIZE)

# Optimize model
m.optimize()

# Check if an optimal solution was found
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    for v in m.getVars():
        print(f"{v.varName}: {v.x}")
else:
    print("No optimal solution found.")

