
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("vitamin_optimization")

    # Create variables
    x0 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x0") # milligrams of vitamin D
    x1 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x1") # milligrams of vitamin E
    x2 = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="x2") # milligrams of vitamin B12


    # Set objective function
    model.setObjective(8.93*x0**2 + 5.74*x0*x1 + 5.48*x1**2 + 4.59*x1*x2 + 9.79*x0 + 1.66*x1 + 8.3*x2, gp.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(29*x0 + 8*x1 + 26*x2 <= 154, "c0")
    model.addConstr(2*x0 + 22*x1 + 24*x2 <= 261, "c1")
    model.addConstr(8*x1**2 + 26*x2**2 >= 33, "c2")
    model.addConstr(29*x0 + 8*x1 >= 19, "c3")
    model.addConstr(29*x0 + 8*x1 + 26*x2 >= 33, "c4")
    model.addConstr(2*x0**2 + 22*x1**2 >= 74, "c5")
    model.addConstr(2*x0 + 24*x2 >= 70, "c6")
    model.addConstr(29*x0 + 8*x1 <= 87, "c7")
    model.addConstr(29*x0**2 + 26*x2**2 <= 80, "c8")
    model.addConstr(29*x0 + 8*x1 + 26*x2 <= 80, "c9")
    model.addConstr(2*x0**2 + 22*x1**2 <= 174, "c10")
    model.addConstr(22*x1 + 24*x2 <= 104, "c11")
    model.addConstr(2*x0**2 + 24*x2**2 <= 222, "c12")
    model.addConstr(2*x0 + 22*x1 + 24*x2 <= 222, "c13")


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        print('x0: %g' % x0.x)
        print('x1: %g' % x1.x)
        print('x2: %g' % x2.x)
    elif model.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % model.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
