
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("nutrition_optimization")

    # Create variables
    calcium = m.addVar(vtype=gp.GRB.INTEGER, name="calcium")
    vitamin_e = m.addVar(vtype=gp.GRB.CONTINUOUS, name="vitamin_e")
    vitamin_d = m.addVar(vtype=gp.GRB.INTEGER, name="vitamin_d")


    # Set objective function
    m.setObjective(4*calcium + 3*vitamin_e + 2*vitamin_d, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(10*vitamin_e + 10*vitamin_d >= 44, "muscle_growth_e_d")
    m.addConstr(calcium + 10*vitamin_e >= 58, "muscle_growth_ca_e")
    m.addConstr(calcium + 10*vitamin_d >= 54, "muscle_growth_ca_d")
    m.addConstr(calcium + 10*vitamin_e + 10*vitamin_d >= 39, "muscle_growth_all")

    m.addConstr(10*vitamin_e + 2*vitamin_d >= 31, "immune_support_e_d")
    m.addConstr(2*calcium + 2*vitamin_d >= 74, "immune_support_ca_d")
    m.addConstr(2*calcium + 10*vitamin_e + 2*vitamin_d >= 74, "immune_support_all")

    m.addConstr(3*calcium - 9*vitamin_d >= 0, "constraint_1")
    m.addConstr(-9*calcium + 5*vitamin_e >= 0, "constraint_2")

    m.addConstr(2*calcium + 2*vitamin_d <= 189, "immune_support_ca_d_upper")
    m.addConstr(2*calcium + 10*vitamin_e <= 201, "immune_support_ca_e_upper")
    m.addConstr(10*vitamin_e + 2*vitamin_d <= 117, "immune_support_e_d_upper")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('calcium:', calcium.x)
        print('vitamin_e:', vitamin_e.x)
        print('vitamin_d:', vitamin_d.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')

