
import gurobi

# Define the model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(name="milligrams_of_calcium", vtype=gurobi.GRB.INTEGER)  # integer
x2 = model.addVar(name="milligrams_of_vitamin_E", vtype=gurobi.GRB.CONTINUOUS)  # continuous
x3 = model.addVar(name="milligrams_of_vitamin_D", vtype=gurobi.GRB.INTEGER)  # integer

# Define the objective function
model.setObjective(4 * x1 + 3 * x2 + 2 * x3, gurobi.GRB.MINIMIZE)

# Add constraints
model.addConstr(10 * x2 + 10 * x3 >= 44)
model.addConstr(x1 + 10 * x2 >= 58)
model.addConstr(x1 + 10 * x3 >= 54)
model.addConstr(x1 + 10 * x2 + 10 * x3 >= 39)
model.addConstr(10 * x2 + 2 * x3 >= 31)
model.addConstr(2 * x1 + 2 * x3 >= 74)
model.addConstr(2 * x1 + 10 * x2 + 2 * x3 >= 74)
model.addConstr(3 * x1 - 9 * x3 >= 0)
model.addConstr(-9 * x1 + 5 * x2 >= 0)
model.addConstr(2 * x1 + 2 * x3 <= 189)
model.addConstr(2 * x1 + 10 * x2 <= 201)
model.addConstr(10 * x2 + 2 * x3 <= 117)

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Milligrams of calcium: {x1.varValue}")
    print(f"Milligrams of vitamin E: {x2.varValue}")
    print(f"Milligrams of vitamin D: {x3.varValue}")
    print(f"Objective function value: {model.objVal}")
else:
    print("No optimal solution found.")
