
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    cherry_pies = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="cherry_pies")
    lemons = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="lemons")
    tomatoes = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="tomatoes")
    cantaloupes = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="cantaloupes")

    # Set objective function
    model.setObjective(5.28 * cherry_pies + 5.35 * lemons + 5.46 * tomatoes + 3.47 * cantaloupes, gp.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(3 * tomatoes + 13 * cantaloupes >= 125, "c0")
    model.addConstr(11 * cherry_pies + 18 * lemons >= 86, "c1")
    model.addConstr(18 * lemons + 3 * tomatoes >= 107, "c2")
    model.addConstr(18 * lemons + 13 * cantaloupes >= 54, "c3")
    model.addConstr(11 * cherry_pies + 13 * cantaloupes >= 103, "c4")
    model.addConstr(11 * cherry_pies + 3 * tomatoes <= 325, "c5")
    model.addConstr(18 * lemons + 3 * tomatoes <= 415, "c6")
    model.addConstr(18 * lemons + 13 * cantaloupes <= 154, "c7")
    model.addConstr(11 * cherry_pies + 18 * lemons + 3 * tomatoes + 13 * cantaloupes <= 154, "c8")
    model.addConstr(11 * cherry_pies + 18 * lemons + 3 * tomatoes + 13 * cantaloupes <= 518, "c9")


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
    elif model.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % model.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
