
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="cherry_pies", lb=0)  # No lower bound specified, assuming 0
    x2 = model.addVar(name="lemons", lb=0)     # No lower bound specified, assuming 0
    x3 = model.addVar(name="tomatoes", lb=0)  # No lower bound specified, assuming 0
    x4 = model.addVar(name="cantaloupes", lb=0) # No lower bound specified, assuming 0

    # Define the objective function
    model.setObjective(5.28 * x1 + 5.35 * x2 + 5.46 * x3 + 3.47 * x4, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(3 * x3 + 13 * x4 >= 125)
    model.addConstr(11 * x1 + 18 * x2 >= 86)
    model.addConstr(18 * x2 + 3 * x3 >= 107)
    model.addConstr(18 * x2 + 13 * x4 >= 54)
    model.addConstr(11 * x1 + 13 * x4 >= 103)
    model.addConstr(11 * x1 + 3 * x3 <= 325)
    model.addConstr(18 * x2 + 3 * x3 <= 415)
    model.addConstr(18 * x2 + 13 * x4 <= 154)
    model.addConstr(11 * x1 + 18 * x2 + 3 * x3 + 13 * x4 <= 518)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Cherry pies: {x1.varValue}")
        print(f"Lemons: {x2.varValue}")
        print(f"Tomatoes: {x3.varValue}")
        print(f"Cantaloupes: {x4.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
