
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(vtype=GRB.INTEGER, name="x0") # milligrams of vitamin B4
    x1 = m.addVar(vtype=GRB.INTEGER, name="x1") # milligrams of calcium
    x2 = m.addVar(vtype=GRB.CONTINUOUS, name="x2") # grams of carbohydrates


    # Set objective function
    m.setObjective(9.36*x0**2 + 9.52*x0*x1 + 9.56*x0*x2 + 7.32*x1**2 + 4.46*x1*x2 + 1.98*x2**2 + 1.78*x0 + 7.27*x1 + 4.88*x2, GRB.MINIMIZE)

    # Add constraints
    m.addConstr(6*x0 + 3*x1 >= 12, "c0")
    m.addConstr(6*x0 + 9*x2 >= 11, "c1")
    m.addConstr(6*x0 + 3*x1 + 9*x2 >= 11, "c2")
    m.addConstr(-6*x0**2 + 8*x1**2 >= 0, "c3")
    m.addConstr(6*x0 + 3*x1 + 9*x2 <= 49, "c4")


    # Optimize model
    m.optimize()

    if m.status == GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)



except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
