
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="milligrams_of_vitamin_B4")
x2 = m.addVar(vtype=GRB.INTEGER, name="milligrams_of_calcium")
x3 = m.addVar(vtype=GRB.CONTINUOUS, name="grams_of_carbohydrates")

# Define the objective function
m.setObjective(9.36*x1**2 + 9.52*x1*x2 + 9.56*x1*x3 + 7.32*x2**2 + 4.46*x2*x3 + 1.98*x3**2 + 1.78*x1 + 7.27*x2 + 4.88*x3, GRB.MINIMIZE)

# Add constraints
m.addConstr(6*x1 + 3*x2 >= 12, "immune_support_index_1")
m.addConstr(6*x1 + 9*x3 >= 11, "immune_support_index_2")
m.addConstr(6*x1 + 3*x2 + 9*x3 >= 11, "total-immune-support-index")
m.addConstr(-6*x1**2 + 8*x2**2 >= 0, "quadratic_constraint")
m.addConstr(6*x1 + 3*x2 + 9*x3 <= 49, "upper_bound_total_immunity")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Milligrams of vitamin B4: {x1.x}")
    print(f"Milligrams of calcium: {x2.x}")
    print(f"Grams of carbohydrates: {x3.x}")
else:
    print("No optimal solution found")
