
import gurobi

def optimize_problem():
    model = gurobi.Model()
    
    # Define variables
    x1 = model.addVar(name="milligrams_of_vitamin_B4", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="milligrams_of_calcium", vtype=gurobi.GRB.INTEGER)
    x3 = model.addVar(name="grams_of_carbohydrates")
    
    # Objective function
    model.setObjective(9.36*x1**2 + 9.52*x1*x2 + 9.56*x1*x3 + 7.32*x2**2 + 4.46*x2*x3 + 1.98*x3**2 + 1.78*x1 + 7.27*x2 + 4.88*x3, gurobi.GRB.MINIMIZE)
    
    # Constraints
    model.addConstr(6*x1 <= 102)
    model.addConstr(3*x2 <= 102)
    model.addConstr(9*x3 <= 102)
    model.addConstr(6*x1 + 3*x2 >= 12)
    model.addConstr(6*x1 + 9*x3 >= 11)
    model.addConstr(6*x1 + 3*x2 + 9*x3 >= 11)
    model.addConstr(-6*x1**2 + 8*x2**2 >= 0)
    model.addConstr(6*x1 + 3*x2 + 9*x3 <= 49)
    
    # Optimize
    model.optimize()
    
    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("x1: ", x1.varValue)
        print("x2: ", x2.varValue)
        print("x3: ", x3.varValue)
    else:
        print("The model is infeasible")

optimize_problem()
