
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(name="x0")  # milligrams of zinc
    x1 = m.addVar(name="x1")  # grams of protein
    x2 = m.addVar(name="x2")  # milligrams of vitamin K


    # Set objective function
    m.setObjective(2.24*x0*x1 + 1.49*x0*x2 + 6.98*x2**2 + 8.11*x0 + 4.52*x1 + 9.76*x2, GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(9*x0 + 3*x2 >= 55)
    m.addConstr(8*x0**2 + 1*x2**2 >= 20)
    m.addConstr(8*x0 + 11*x1 >= 20)
    m.addConstr(3*x0 + 7*x1 >= 33)
    m.addConstr(10*x0 + 8*x1 >= 31)
    m.addConstr(9*x0**2 + 13*x1**2 <= 151)
    m.addConstr(9*x0 + 3*x2 <= 110)
    m.addConstr(13*x1 + 3*x2 <= 162)
    m.addConstr(9*x0 + 13*x1 + 3*x2 <= 162)
    m.addConstr(8*x0**2 + 11*x1**2 <= 66)
    m.addConstr(11*x1 + 1*x2 <= 65)
    m.addConstr(8*x0 + 1*x2 <= 59)
    m.addConstr(8*x0 + 11*x1 + 1*x2 <= 59)
    m.addConstr(3*x0**2 + 4*x2**2 <= 83)
    m.addConstr(7*x1 + 4*x2 <= 149)
    m.addConstr(3*x0 + 7*x1 + 4*x2 <= 149)
    m.addConstr(10*x0**2 + 3*x2**2 <= 69)
    m.addConstr(8*x1 + 3*x2 <= 91)
    m.addConstr(10*x0 + 8*x1 + 3*x2 <= 91)


    # Optimize model
    m.optimize()

    if m.status == GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
