
import gurobi

# Create a new Gurobi model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="milligrams_of_zinc", lb=-float('inf'), ub=float('inf'))
x1 = m.addVar(name="grams_of_protein", lb=-float('inf'), ub=float('inf'))
x2 = m.addVar(name="milligrams_of_vitamin_K", lb=-float('inf'), ub=float('inf'))

# Objective function
m.setObjective(2.24*x0*x1 + 1.49*x0*x2 + 6.98*x2**2 + 8.11*x0 + 4.52*x1 + 9.76*x2, gurobi.GRB.MAXIMIZE)

# Constraints
m.addConstr(9*x0 <= 218)
m.addConstr(8*x0 <= 93)
m.addConstr(3*x0 <= 175)
m.addConstr(10*x0 <= 140)
m.addConstr(13*x1 <= 218)
m.addConstr(11*x1 <= 93)
m.addConstr(7*x1 <= 175)
m.addConstr(8*x1 <= 140)
m.addConstr(3*x2 <= 218)
m.addConstr(x2 <= 93)
m.addConstr(4*x2 <= 175)
m.addConstr(3*x2 <= 140)
m.addConstr(9*x0 + 3*x2 >= 55)
m.addConstr(64*x0**2 + x2**2 >= 20)
m.addConstr(8*x0 + 11*x1 >= 20)
m.addConstr(3*x0 + 7*x1 >= 33)
m.addConstr(10*x0 + 8*x1 >= 31)
m.addConstr(81*x0**2 + 169*x1**2 <= 151)
m.addConstr(9*x0 + 3*x2 <= 110)
m.addConstr(13*x1 + 3*x2 <= 162)
m.addConstr(9*x0 + 13*x1 + 3*x2 <= 162)
m.addConstr(64*x0**2 + 121*x1**2 <= 66)
m.addConstr(11*x1 + x2 <= 65)
m.addConstr(8*x0 + x2 <= 59)
m.addConstr(8*x0 + 11*x1 + x2 <= 59)
m.addConstr(9*x0**2 + 16*x2**2 <= 83)
m.addConstr(7*x1 + 4*x2 <= 149)
m.addConstr(3*x0 + 7*x1 + 4*x2 <= 149)
m.addConstr(100*x0**2 + 9*x2**2 <= 69)
m.addConstr(8*x1 + 3*x2 <= 91)
m.addConstr(10*x0 + 8*x1 + 3*x2 <= 91)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.Status.OPTIMAL:
    print("Optimal solution found.")
    print(f"Milligrams of zinc: {x0.varValue}")
    print(f"Grams of protein: {x1.varValue}")
    print(f"Milligrams of vitamin K: {x2.varValue}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
