
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_model")

# Create variables
x = m.addVars(5, lb=0, vtype=gp.GRB.CONTINUOUS, name=["Bill", "George", "Dale", "Hank", "Mary"])

# Set objective function
m.setObjective(4.59*x[0]*x[1] + 9.42*x[0]*x[2] + 7.04*x[0]*x[4] + 8.5*x[1]*x[2] + 2.53*x[1]*x[4] + 2.72*x[3]**2 + 7.49*x[3]*x[4] + 4.85*x[4]**2 + 3.42*x[0] + 5.86*x[1] + 1.44*x[4], gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(13*x[0] + 13*x[1] >= 29)
m.addConstr(15*x[2] + 11*x[4] >= 29)
m.addConstr(13*x[0] + 15*x[2] >= 29)
m.addConstr(13*x[0] + 16*x[3] >= 48)
m.addConstr(13*x[0] + 16*x[3] + 11*x[4] >= 49)
m.addConstr(13*x[0] + 13*x[1] + 15*x[2] + 16*x[3] + 11*x[4] >= 49)
m.addConstr(6*x[0] + 17*x[1] >= 58)
m.addConstr(16*x[3]**2 + 5*x[4]**2 >= 86)
m.addConstr(2*x[2] + 16*x[3] >= 62)
m.addConstr(17*x[1]**2 + 16*x[3]**2 + 5*x[4]**2 >= 99)
m.addConstr(17*x[1] + 2*x[2] + 5*x[4] >= 99)
m.addConstr(6*x[0] + 2*x[2] + 5*x[4] >= 99)
m.addConstr(17*x[1] + 2*x[2] + 16*x[3] >= 99)
m.addConstr(17*x[1] + 16*x[3] + 5*x[4] >= 56)
m.addConstr(17*x[1] + 2*x[2] + 5*x[4] >= 56)
m.addConstr(6*x[0]**2 + 2*x[2]**2 + 5*x[4]**2 >= 56)
m.addConstr(17*x[1] + 2*x[2] + 16*x[3] >= 56)
m.addConstr(17*x[1] + 16*x[3] + 5*x[4] >= 79)
m.addConstr(17*x[1]**2 + 2*x[2]**2 + 5*x[4]**2 >= 79)
m.addConstr(6*x[0] + 2*x[2] + 5*x[4] >= 79)
m.addConstr(17*x[1]**2 + 2*x[2]**2 + 16*x[3]**2 >= 79)
m.addConstr(17*x[1]**2 + 16*x[3]**2 + 5*x[4]**2 >= 65)
m.addConstr(17*x[1]**2 + 2*x[2]**2 + 5*x[4]**2 >= 65)
m.addConstr(6*x[0]**2 + 2*x[2]**2 + 5*x[4]**2 >= 65)
m.addConstr(17*x[1]**2 + 2*x[2]**2 + 16*x[3]**2 >= 65)
m.addConstr(6*x[0] + 17*x[1] + 2*x[2] + 16*x[3] + 5*x[4] >= 65)
m.addConstr(9*x[0]**2 - 4*x[1]**2 >= 0)
m.addConstr(-9*x[2] + 9*x[3] >= 0)
m.addConstr(13*x[0]**2 + 11*x[4]**2 <= 100)
m.addConstr(13*x[0]**2 + 16*x[3]**2 <= 197)
m.addConstr(13*x[1] + 11*x[4] <= 80)
m.addConstr(15*x[2] + 16*x[3] <= 80)
m.addConstr(13*x[1] + 15*x[2] <= 305)
m.addConstr(13*x[0] + 15*x[2] <= 77)
m.addConstr(13*x[0] + 13*x[1] <= 118)
m.addConstr(13*x[0] + 15*x[2] + 11*x[4] <= 143)
m.addConstr(15*x[2]**2 + 16*x[3]**2 + 11*x[4]**2 <= 213)
m.addConstr(17*x[1] + 5*x[4] <= 272)
m.addConstr(6*x[0] + 5*x[4] <= 288)
m.addConstr(2*x[2] + 16*x[3] <= 457)
m.addConstr(6*x[0] + 17*x[1] + 5*x[4] <= 411)
m.addConstr(6*x[0] + 17*x[1] + 2*x[2] <= 191)
m.addConstr(17*x[1] + 16*x[3] + 5*x[4] <= 354)
m.addConstr(6*x[0]**2 + 17*x[1]**2 + 16*x[3]**2 <= 354)
m.addConstr(6*x[0] + 2*x[2] + 16*x[3] <= 286)
m.addConstr(6*x[0] + 2*x[2] + 5*x[4] <= 418)
m.addConstr(6*x[0]**2 + 16*x[3]**2 + 5*x[4]**2 <= 239)
m.addConstr(17*x[1] + 2*x[2] + 5*x[4] <= 350)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
    print('Obj: %g' % m.objVal)
elif m.status == gp.GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print('Optimization ended with status %d' % m.status)
