
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimization_model")

    # Create variables
    x0 = model.addVar(vtype=gp.GRB.CONTINUOUS, name="x0")  # hours worked by Jean
    x1 = model.addVar(vtype=gp.GRB.CONTINUOUS, name="x1")  # hours worked by Peggy
    x2 = model.addVar(vtype=gp.GRB.CONTINUOUS, name="x2")  # hours worked by Laura
    x3 = model.addVar(vtype=gp.GRB.CONTINUOUS, name="x3")  # hours worked by Hank


    # Set objective function
    model.setObjective(7.27*x0 + 5.88*x1 + 2.44*x2 + 4.19*x3, gp.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(4*x0 + 19*x1 >= 38)
    model.addConstr(19*x1 + 23*x2 >= 29)
    model.addConstr(19*x1 + 22*x3 >= 23)
    model.addConstr(23*x2 + 22*x3 >= 27)
    model.addConstr(4*x0 + 19*x1 + 23*x2 + 22*x3 >= 27)
    model.addConstr(3*x0 - 8*x1 >= 0)
    model.addConstr(-2*x0 + 5*x2 >= 0)
    model.addConstr(19*x1 + 23*x2 <= 199)
    model.addConstr(4*x0 + 23*x2 <= 169)
    model.addConstr(4*x0 + 23*x2 + 22*x3 <= 206)
    model.addConstr(19*x1 + 23*x2 + 22*x3 <= 135)
    model.addConstr(4*x0 + 19*x1 + 23*x2 <= 108)


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
    elif model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {model.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
