
import gurobi

def optimize_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name='x1', lb=0)  # hours worked by Jean
    x2 = model.addVar(name='x2', lb=0)  # hours worked by Peggy
    x3 = model.addVar(name='x3', lb=0)  # hours worked by Laura
    x4 = model.addVar(name='x4', lb=0)  # hours worked by Hank

    # Define the objective function
    model.setObjective(7.27 * x1 + 5.88 * x2 + 2.44 * x3 + 4.19 * x4, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(4 * x1 + 19 * x2 >= 38)
    model.addConstr(19 * x2 + 23 * x3 >= 29)
    model.addConstr(19 * x2 + 22 * x4 >= 23)
    model.addConstr(23 * x3 + 22 * x4 >= 27)
    model.addConstr(4 * x1 + 19 * x2 + 23 * x3 + 22 * x4 >= 27)
    model.addConstr(3 * x1 - 8 * x2 >= 0)
    model.addConstr(-2 * x1 + 5 * x3 >= 0)
    model.addConstr(19 * x2 + 23 * x3 <= 199)
    model.addConstr(4 * x1 + 23 * x3 <= 169)
    model.addConstr(4 * x1 + 23 * x3 + 22 * x4 <= 206)
    model.addConstr(19 * x2 + 23 * x3 + 22 * x4 <= 135)
    model.addConstr(4 * x1 + 19 * x2 + 23 * x3 <= 108)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Objective: ', model.objVal)
        print('x1: ', x1.varValue)
        print('x2: ', x2.varValue)
        print('x3: ', x3.varValue)
        print('x4: ', x4.varValue)
    else:
        print('The model is infeasible')

optimize_problem()
