
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    x0 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x0") # milligrams of vitamin A
    x1 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x1") # grams of fiber


    # Set objective function
    model.setObjective(7.92*x0**2 + 4.18*x0 + 2.24*x1, gp.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(2*x0 + 8*x1 <= 141, "c0")
    model.addConstr(7*x0 + 4*x1 <= 68, "c1")
    model.addConstr(2*x0 + x1 <= 152, "c2")
    model.addConstr(2*x0**2 + 8*x1**2 >= 53, "c3")
    model.addConstr(7*x0 + 4*x1 >= 16, "c4")
    model.addConstr(2*x0 + x1 >= 72, "c5")
    model.addConstr(7*x0 - 3*x1 >= 0, "c6")
    model.addConstr(2*x0**2 + 8*x1**2 <= 80, "c7")
    model.addConstr(2*x0 + 8*x1 <= 80, "c8")
    model.addConstr(7*x0 + 4*x1 <= 46, "c9")
    model.addConstr(2*x0 + x1 <= 85, "c10")


    # Optimize model
    model.optimize()

    # Check for infeasibility
    if model.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        # Print optimal solution
        print("Optimal objective value:", model.objVal)
        print("x0 (milligrams of vitamin A):", x0.x)
        print("x1 (grams of fiber):", x1.x)

except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ": " + str(e))

except AttributeError:
    print('Encountered an attribute error')
