
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(lb=-GRB.INFINITY, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_A")
x2 = m.addVar(lb=-GRB.INFINITY, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS, name="grams_of_fiber")

# Define the objective function
m.setObjective(7.92*x1**2 + 4.18*x1 + 2.24*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(2*x1**2 + 8*x2**2 >= 53, "digestive_support_index_min")
m.addConstr(2*x1**2 + 8*x2**2 <= 80, "digestive_support_index_max")
m.addConstr(7*x1 + 4*x2 >= 16, "immune_support_index_min")
m.addConstr(7*x1 + 4*x2 <= 46, "immune_support_index_max")
m.addConstr(2*x1 + x2 >= 72, "energy_stability_index_min")
m.addConstr(2*x1 + x2 <= 85, "energy_stability_index_max")
m.addConstr(7*x1 - 3*x2 >= 0, "additional_constraint")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Milligrams of Vitamin A: {x1.x}")
    print(f"Grams of Fiber: {x2.x}")
    print(f"Objective Function Value: {m.objVal}")
else:
    print("No optimal solution found")
