
import gurobi

def optimize_problem():
    model = gurobi.Model()
    
    # Define variables
    x1 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="milligrams_of_vitamin_A")
    x2 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="grams_of_fiber")
    
    # Objective function
    model.setObjective(7.92*x1**2 + 4.18*x1 + 2.24*x2, gurobi.GRB.MAXIMIZE)
    
    # Constraints
    model.addConstr(2*x1 <= 141)
    model.addConstr(7*x1 <= 68)
    model.addConstr(2*x1 <= 152)
    model.addConstr(8*x2 <= 141)
    model.addConstr(4*x2 <= 68)
    model.addConstr(x2 <= 152)
    model.addConstr(2*x1**2 + 8*x2**2 >= 53)
    model.addConstr(7*x1 + 4*x2 >= 16)
    model.addConstr(2*x1 + x2 >= 72)
    model.addConstr(7*x1 - 3*x2 >= 0)
    model.addConstr(2*x1**2 + 8*x2**2 <= 80)
    model.addConstr(2*x1 + 8*x2 <= 80)
    model.addConstr(7*x1 + 4*x2 <= 46)
    model.addConstr(2*x1 + x2 <= 85)
    
    # Optimize
    model.optimize()
    
    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin A: {x1.varValue}")
        print(f"Grams of fiber: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize_problem()
