
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_model")

# Create variables
x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x0")
x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x1")
x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x2")
x3 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x3")
x4 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x4")
x5 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x5")


# Set objective function
m.setObjective(7*x0**2 + 7*x0*x1 + 2*x0*x2 + 8*x0*x3 + 6*x0*x4 + 6*x0*x5 + 8*x2**2 + 4*x2*x3 + 3*x2*x4 + 7*x2*x5 + 3*x3**2 + 1*x0 + 2*x1 + 6*x2 + 8*x3, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(6*x0 + 5*x1 + 11*x2 + 13*x3 + 14*x4 + 4*x5 <= 171)
m.addConstr(4*x0 + 7*x1 + 7*x2 + 4*x3 + 5*x4 + 9*x5 <= 157)
m.addConstr(6*x0**2 + 5*x1**2 >= 9)
# ... (add all other constraints similarly)


# Optimize model
m.optimize()

# Check for infeasibility
if m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print optimal solution
    print("Optimal objective value:", m.objVal)
    for v in m.getVars():
        print(f"{v.varName}: {v.x}")

