
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
cherry_pies = m.addVar(lb=0, name="cherry_pies")
bananas = m.addVar(lb=0, name="bananas")
ravioli = m.addVar(lb=0, name="ravioli")
green_beans = m.addVar(lb=0, name="green_beans")


# Set objective function
m.setObjective(8.05*cherry_pies**2 + 8.88*cherry_pies*bananas + 7.15*cherry_pies*ravioli + 2.14*cherry_pies*green_beans + 7.51*bananas**2 + 1.52*ravioli**2 + 5.89*ravioli*green_beans + 9.32*cherry_pies + 8.08*bananas + 3.46*ravioli + 5.17*green_beans, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(0.37*cherry_pies + 2.59*ravioli >= 19)
m.addConstr(0.37*cherry_pies + 1.69*bananas >= 41)
m.addConstr(1.69*bananas**2 + 2.59*ravioli**2 >= 18)
m.addConstr(1.42*cherry_pies**2 + 2.76*bananas**2 + 2.84*green_beans**2 >= 38)
m.addConstr(2.76*bananas + 0.31*ravioli + 2.84*green_beans >= 38)
m.addConstr(1.42*cherry_pies + 2.76*bananas + 2.84*green_beans >= 66)
m.addConstr(2.76*bananas + 0.31*ravioli + 2.84*green_beans >= 66)
m.addConstr(2.51*bananas**2 + 1.98*ravioli**2 >= 17)
m.addConstr(2.87*cherry_pies + 2.5*green_beans >= 10)
m.addConstr(2.51*bananas**2 + 2.5*green_beans**2 >= 15)
m.addConstr(2.87*cherry_pies + 2.51*bananas >= 11)
m.addConstr(1.98*ravioli + 2.5*green_beans >= 10)
m.addConstr(2.87*cherry_pies**2 + 2.51*bananas**2 + 2.5*green_beans**2 >= 11)
m.addConstr(1.81*cherry_pies + 0.87*green_beans >= 15)
m.addConstr(1.81*cherry_pies + 1.47*bananas >= 39)
m.addConstr(1.47*bananas**2 + 0.87*green_beans**2 >= 40)
m.addConstr(0.14*ravioli + 0.87*green_beans >= 29)
m.addConstr(1.81*cherry_pies + 0.14*ravioli + 0.87*green_beans >= 33)
m.addConstr(1.69*bananas + 0.36*green_beans <= 171)
m.addConstr(1.69*bananas + 2.59*ravioli <= 183)
m.addConstr(0.37*cherry_pies + 2.59*ravioli <= 196)
m.addConstr(0.37*cherry_pies + 1.69*bananas <= 140)
m.addConstr(2.59*ravioli + 0.36*green_beans <= 192)
m.addConstr(0.37*cherry_pies + 1.69*bananas + 2.59*ravioli <= 142)
m.addConstr(0.37*cherry_pies + 1.69*bananas + 2.59*ravioli + 0.36*green_beans <= 142)
m.addConstr(1.42*cherry_pies**2 + 2.76*bananas**2 <= 99)
m.addConstr(0.31*ravioli + 2.84*green_beans <= 164)
m.addConstr(1.42*cherry_pies + 2.84*green_beans <= 103)
m.addConstr(2.76*bananas**2 + 0.31*ravioli**2 <= 140)
m.addConstr(1.42*cherry_pies**2 + 2.76*bananas**2 + 0.31*ravioli**2 <= 267)
m.addConstr(1.42*cherry_pies + 2.76*bananas + 0.31*ravioli + 2.84*green_beans <= 267)
m.addConstr(2.51*bananas + 2.5*green_beans <= 60)
m.addConstr(2.87*cherry_pies + 2.5*green_beans <= 80)
m.addConstr(2.51*bananas**2 + 1.98*ravioli**2 <= 75)
m.addConstr(2.87*cherry_pies**2 + 1.98*ravioli**2 <= 51)
m.addConstr(2.87*cherry_pies**2 + 2.51*bananas**2 <= 66)
m.addConstr(2.87*cherry_pies + 2.51*bananas + 1.98*ravioli + 2.5*green_beans <= 66)
m.addConstr(1.47*bananas**2 + 0.14*ravioli**2 <= 143)
m.addConstr(1.81*cherry_pies + 0.14*ravioli <= 59)
m.addConstr(1.81*cherry_pies**2 + 0.87*green_beans**2 <= 67)
m.addConstr(0.14*ravioli + 0.87*green_beans <= 109)
m.addConstr(1.47*bananas**2 + 0.87*green_beans**2 <= 112)
m.addConstr(1.47*bananas**2 + 0.14*ravioli**2 + 0.87*green_beans**2 <= 139)
m.addConstr(1.81*cherry_pies + 1.47*bananas + 0.14*ravioli <= 110)
m.addConstr(1.81*cherry_pies + 1.47*bananas + 0.87*green_beans <= 134)
m.addConstr(1.81*cherry_pies + 1.47*bananas + 0.14*ravioli + 0.87*green_beans <= 134)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The problem is infeasible.")
else:
    print("The problem could not be solved to optimality.")

