
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
headsets = m.addVar(vtype=gp.GRB.INTEGER, name="headsets")
color_printers = m.addVar(vtype=gp.GRB.INTEGER, name="color_printers")
blue_highlighters = m.addVar(vtype=gp.GRB.INTEGER, name="blue_highlighters")
usb_flash_drives = m.addVar(vtype=gp.GRB.INTEGER, name="usb_flash_drives")
mechanical_pencils = m.addVar(vtype=gp.GRB.INTEGER, name="mechanical_pencils")

# Set objective function
m.setObjective(3.93 * headsets + 2.1 * color_printers + 1.18 * blue_highlighters + 1.57 * usb_flash_drives + 6.78 * mechanical_pencils, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(2.55 * headsets + 1.31 * color_printers >= 51)
m.addConstr(1.31 * color_printers + 4.06 * usb_flash_drives >= 78)
m.addConstr(2.55 * headsets + 1.31 * color_printers + 4.06 * usb_flash_drives >= 86)
m.addConstr(1.31 * color_printers + 8.32 * blue_highlighters + 0.91 * mechanical_pencils >= 86)
# ... (add all other constraints similarly)
m.addConstr(11.86 * headsets + 9.37 * color_printers + 0.62 * blue_highlighters + 12.6 * usb_flash_drives + 8.74 * mechanical_pencils <= 449)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('headsets:', headsets.x)
    print('color_printers:', color_printers.x)
    print('blue_highlighters:', blue_highlighters.x)
    print('usb_flash_drives:', usb_flash_drives.x)
    print('mechanical_pencils:', mechanical_pencils.x)

elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

