
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
chicken_breasts = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="chicken_breasts")
rotisserie_chickens = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="rotisserie_chickens")
cantaloupes = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="cantaloupes")
potatoes = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="potatoes")


# Set objective function
m.setObjective(3*chicken_breasts**2 + 6*chicken_breasts*rotisserie_chickens + 7*chicken_breasts*cantaloupes + 9*chicken_breasts*potatoes + 5*rotisserie_chickens**2 + 1*rotisserie_chickens*cantaloupes + 5*cantaloupes**2 + 8*cantaloupes*potatoes + 6*chicken_breasts + 5*rotisserie_chickens + 3*cantaloupes + 8*potatoes, GRB.MAXIMIZE)

# Add constraints
m.addConstr(14*rotisserie_chickens**2 + 4*cantaloupes**2 + 19*potatoes**2 >= 18)
m.addConstr(20*chicken_breasts**2 + 4*cantaloupes**2 + 19*potatoes**2 >= 18)
m.addConstr(14*rotisserie_chickens + 4*cantaloupes + 19*potatoes >= 25)
m.addConstr(20*chicken_breasts + 4*cantaloupes + 19*potatoes >= 25)
m.addConstr(21*rotisserie_chickens + 21*potatoes >= 14)
m.addConstr(9*cantaloupes + 21*potatoes >= 19)
m.addConstr(9*chicken_breasts**2 + 21*rotisserie_chickens**2 + 9*cantaloupes**2 >= 27)
m.addConstr(9*chicken_breasts + 21*rotisserie_chickens + 21*potatoes >= 27)
m.addConstr(9*chicken_breasts + 21*rotisserie_chickens + 9*cantaloupes >= 23)
m.addConstr(9*chicken_breasts + 21*rotisserie_chickens + 21*potatoes >= 23)
m.addConstr(4*cantaloupes + 19*potatoes <= 90)
m.addConstr(20*chicken_breasts + 14*rotisserie_chickens <= 43)
m.addConstr(20*chicken_breasts + 14*rotisserie_chickens + 4*cantaloupes + 19*potatoes <= 43)
m.addConstr(9*chicken_breasts + 21*rotisserie_chickens <= 173)
m.addConstr(9*chicken_breasts + 21*rotisserie_chickens + 9*cantaloupes + 21*potatoes <= 173)
m.addConstr(20*chicken_breasts + 14*rotisserie_chickens + 4*cantaloupes + 19*potatoes <= 109)
m.addConstr(9*chicken_breasts + 21*rotisserie_chickens + 9*cantaloupes + 21*potatoes <= 173)


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

