
import gurobi

# Define the model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="chicken_breasts", lb=0)
x1 = m.addVar(name="rotisserie_chickens", lb=0)
x2 = m.addVar(name="cantaloupes", lb=0)
x3 = m.addVar(name="potatoes", lb=0)

# Define the objective function
m.setObjective(3*x0**2 + 6*x0*x1 + 7*x0*x2 + 9*x0*x3 + 5*x1**2 + x1*x2 + 5*x2**2 + 8*x2*x3 + 6*x0 + 5*x1 + 3*x2 + 8*x3, gurobi.GRB.MAXIMIZE)

# Add constraints
m.addConstr(20*x0 <= 109)
m.addConstr(9*x0 <= 173)
m.addConstr(14*x1 <= 109)
m.addConstr(21*x1 <= 173)
m.addConstr(4*x2 <= 109)
m.addConstr(9*x2 <= 173)
m.addConstr(19*x3 <= 109)
m.addConstr(21*x3 <= 173)
m.addConstr(x1**2 + x2**2 + x3**2 >= 18)
m.addConstr(x0**2 + x2**2 + x3**2 >= 18)
m.addConstr(14*x1 + 4*x2 + 19*x3 >= 25)
m.addConstr(20*x0 + 4*x2 + 19*x3 >= 25)
m.addConstr(21*x1 + 21*x3 >= 14)
m.addConstr(9*x2 + 21*x3 >= 19)
m.addConstr(9*x0**2 + 21*x1**2 + 9*x2**2 >= 27)
m.addConstr(9*x0 + 21*x1 + 21*x3 >= 27)
m.addConstr(9*x0 + 21*x1 + 9*x2 >= 23)
m.addConstr(9*x0 + 21*x1 + 21*x3 >= 23)
m.addConstr(4*x2 + 19*x3 <= 90)
m.addConstr(20*x0 + 14*x1 <= 43)
m.addConstr(20*x0 + 14*x1 + 4*x2 + 19*x3 <= 43)
m.addConstr(9*x0 + 21*x1 <= 173)
m.addConstr(9*x0 + 21*x1 + 9*x2 + 21*x3 <= 173)

# Optimize the model
m.optimize()

# Print the solution
print("Objective: ", m.objVal)
print("Chicken Breasts: ", x0.varValue)
print("Rotisserie Chickens: ", x1.varValue)
print("Cantaloupes: ", x2.varValue)
print("Potatoes: ", x3.varValue)

