
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_model")

    # Create variables
    security_engineers = m.addVar(vtype=gp.GRB.INTEGER, name="security_engineers")
    soc_operators = m.addVar(vtype=gp.GRB.INTEGER, name="soc_operators")
    system_administrators = m.addVar(vtype=gp.GRB.INTEGER, name="system_administrators")
    patches_per_day = m.addVar(vtype=gp.GRB.INTEGER, name="patches_per_day")
    automatic_alerts = m.addVar(vtype=gp.GRB.INTEGER, name="automatic_alerts")


    # Set objective function
    m.setObjective(2*security_engineers**2 + 3*soc_operators**2 + 9*soc_operators*system_administrators + 4*patches_per_day**2 + 6*automatic_alerts**2 + system_administrators, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(5.78*security_engineers + 5.57*soc_operators + 6.87*system_administrators + 0.77*patches_per_day + 7.52*automatic_alerts <= 707, "c0")
    m.addConstr(1.81*security_engineers + 5.76*soc_operators + 5.12*system_administrators + 1.81*patches_per_day + 2.47*automatic_alerts <= 229, "c1")
    m.addConstr(5.12*system_administrators + 1.81*patches_per_day + 2.47*automatic_alerts >= 22, "c2")
    m.addConstr(1.81*security_engineers + 5.12*system_administrators + 1.81*patches_per_day >= 22, "c3")
    m.addConstr(5.12*system_administrators**2 + 1.81*patches_per_day**2 + 2.47*automatic_alerts**2 >= 44, "c4")
    m.addConstr(1.81*security_engineers + 5.12*system_administrators + 1.81*patches_per_day >= 44, "c5")
    m.addConstr(4*security_engineers**2 - 8*soc_operators**2 + 4*system_administrators**2 >= 0, "c6")
    m.addConstr(5.57*soc_operators + 6.87*system_administrators <= 170, "c7")
    m.addConstr(5.78*security_engineers + 0.77*patches_per_day <= 543, "c8")
    m.addConstr(5.57*soc_operators + 7.52*automatic_alerts <= 184, "c9")
    m.addConstr(5.57*soc_operators + 0.77*patches_per_day <= 258, "c10")
    m.addConstr(5.78*security_engineers + 6.87*system_administrators <= 545, "c11")
    m.addConstr(5.78*security_engineers + 5.57*soc_operators + 6.87*system_administrators + 0.77*patches_per_day + 7.52*automatic_alerts <= 545, "c12")
    m.addConstr(5.12*system_administrators + 1.81*patches_per_day <= 65, "c13")
    m.addConstr(5.76*soc_operators + 2.47*automatic_alerts <= 225, "c14")
    m.addConstr(1.81*security_engineers + 1.81*patches_per_day <= 90, "c15")
    m.addConstr(5.76*soc_operators**2 + 5.12*system_administrators**2 <= 166, "c16")
    m.addConstr(1.81*security_engineers**2 + 2.47*automatic_alerts**2 <= 189, "c17")
    m.addConstr(5.76*soc_operators + 1.81*patches_per_day <= 199, "c18")
    m.addConstr(1.81*security_engineers**2 + 5.76*soc_operators**2 <= 71, "c19")
    m.addConstr(5.12*system_administrators**2 + 1.81*patches_per_day**2 + 2.47*automatic_alerts**2 <= 163, "c20")
    m.addConstr(1.81*security_engineers**2 + 5.12*system_administrators**2 + 2.47*automatic_alerts**2 <= 102, "c21")
    m.addConstr(1.81*security_engineers + 5.76*soc_operators + 5.12*system_administrators + 1.81*patches_per_day + 2.47*automatic_alerts <= 102, "c22")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
