
import gurobi as gp

# Define the model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(name="security_engineers", vtype=gp.GRB.INTEGER)
x1 = m.addVar(name="SOC_operators", vtype=gp.GRB.INTEGER)
x2 = m.addVar(name="system_administrators", vtype=gp.GRB.INTEGER)
x3 = m.addVar(name="patches_per_day", vtype=gp.GRB.INTEGER)
x4 = m.addVar(name="automatic_alerts", vtype=gp.GRB.INTEGER)

# Define the objective function
m.setObjective(2*x0**2 + 3*x1**2 + 9*x1*x2 + 4*x3**2 + 6*x4**2 + x2, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(5.78*x0 + 5.57*x1 + 6.87*x2 + 0.77*x3 + 7.52*x4 <= 707)
m.addConstr(1.81*x0 + 5.76*x1 + 5.12*x2 + 1.81*x3 + 2.47*x4 <= 229)
m.addConstr(1.81*x2 + 1.81*x3 + 2.47*x4 >= 22)
m.addConstr(1.81*x0 + 5.12*x2 + 1.81*x3 >= 22)
m.addConstr(x2**2 + x3**2 + x4**2 >= 44)
m.addConstr(1.81*x0 + 5.12*x2 + 1.81*x3 >= 44)
m.addConstr(4*x0**2 - 8*x1**2 + 4*x2**2 >= 0)
m.addConstr(5.57*x1 + 6.87*x2 <= 170)
m.addConstr(5.78*x0 + 0.77*x3 <= 543)
m.addConstr(5.57*x1 + 7.52*x4 <= 184)
m.addConstr(5.57*x1 + 0.77*x3 <= 258)
m.addConstr(5.78*x0 + 6.87*x2 <= 545)
m.addConstr(5.78*x0 + 5.57*x1 + 6.87*x2 + 0.77*x3 + 7.52*x4 <= 545)
m.addConstr(5.12*x2 + 1.81*x3 <= 65)
m.addConstr(5.76*x1 + 2.47*x4 <= 225)
m.addConstr(1.81*x0 + 1.81*x3 <= 90)
m.addConstr(5.76*x1**2 + 5.12*x2**2 <= 166)
m.addConstr(1.81*x0**2 + 2.47*x4**2 <= 189)
m.addConstr(5.76*x1 + 1.81*x3 <= 199)
m.addConstr(1.81*x0**2 + 5.76*x1**2 <= 71)
m.addConstr(5.12*x2**2 + 1.81*x3**2 + 2.47*x4**2 <= 163)
m.addConstr(1.81*x0**2 + 5.12*x2**2 + 2.47*x4**2 <= 102)
m.addConstr(1.81*x0 + 5.76*x1 + 5.12*x2 + 1.81*x3 + 2.47*x4 <= 102)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Security Engineers: ", x0.varValue)
    print("SOC Operators: ", x1.varValue)
    print("System Administrators: ", x2.varValue)
    print("Patches per Day: ", x3.varValue)
    print("Automatic Alerts: ", x4.varValue)
else:
    print("The model is infeasible.")
