
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.INTEGER, name="x0") # milligrams of vitamin B4
    x1 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x1") # milligrams of iron
    x2 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x2") # milligrams of vitamin B3
    x3 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="x3") # milligrams of calcium


    # Set objective function
    m.setObjective(8*x0 + 5*x1 + 3*x2 + 6*x3, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(10*x0 + x2 >= 88)
    m.addConstr(6*x1 + x2 >= 45)
    m.addConstr(10*x0 + 6*x1 >= 104)
    m.addConstr(6*x1 + 9*x3 >= 124)
    m.addConstr(10*x0 + 6*x1 + 9*x3 >= 88)
    m.addConstr(10*x0 + 6*x1 + x2 >= 88)
    m.addConstr(10*x0 + x2 + 9*x3 >= 88)
    m.addConstr(10*x0 + 6*x1 + 9*x3 >= 106)
    m.addConstr(10*x0 + 6*x1 + x2 >= 106)
    m.addConstr(10*x0 + x2 + 9*x3 >= 106)
    m.addConstr(10*x0 + 6*x1 + 9*x3 >= 81)
    m.addConstr(10*x0 + 6*x1 + x2 >= 81)
    m.addConstr(10*x0 + x2 + 9*x3 >= 81)
    m.addConstr(10*x0 + 6*x1 + x2 + 9*x3 >= 81)
    m.addConstr(-2*x1 + 2*x2 >= 0)
    m.addConstr(10*x0 + 9*x3 <= 365)
    m.addConstr(10*x0 + 6*x1 <= 316)
    m.addConstr(x2 + 9*x3 <= 339)
    m.addConstr(10*x0 + 6*x1 + 9*x3 <= 435)
    m.addConstr(6*x1 + x2 + 9*x3 <= 310)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('The problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
