
import gurobi

def optimize_problem():
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="x1", vtype=gurobi.GRB.INTEGER)  # milligrams of vitamin B4
    x2 = model.addVar(name="x2")  # milligrams of iron
    x3 = model.addVar(name="x3")  # milligrams of vitamin B3
    x4 = model.addVar(name="x4")  # milligrams of calcium

    # Objective function
    model.setObjective(8 * x1 + 5 * x2 + 3 * x3 + 6 * x4, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(10 * x1 + x3 >= 88)
    model.addConstr(6 * x2 + x3 >= 45)
    model.addConstr(10 * x1 + 6 * x2 >= 104)
    model.addConstr(6 * x2 + 9 * x4 >= 124)
    model.addConstr(10 * x1 + 6 * x2 + 9 * x4 >= 88)
    model.addConstr(10 * x1 + 6 * x2 + x3 >= 88)
    model.addConstr(10 * x1 + x3 + 9 * x4 >= 88)
    model.addConstr(10 * x1 + 6 * x2 + 9 * x4 >= 106)
    model.addConstr(10 * x1 + 6 * x2 + x3 >= 106)
    model.addConstr(10 * x1 + x3 + 9 * x4 >= 106)
    model.addConstr(10 * x1 + 6 * x2 + 9 * x4 >= 81)
    model.addConstr(10 * x1 + 6 * x2 + x3 >= 81)
    model.addConstr(10 * x1 + x3 + 9 * x4 >= 81)
    model.addConstr(10 * x1 + 6 * x2 + x3 + 9 * x4 >= 81)
    model.addConstr(-2 * x2 + 2 * x3 >= 0)
    model.addConstr(10 * x1 + 9 * x4 <= 365)
    model.addConstr(10 * x1 + 6 * x2 <= 316)
    model.addConstr(x3 + 9 * x4 <= 339)
    model.addConstr(10 * x1 + 6 * x2 + 9 * x4 <= 435)
    model.addConstr(6 * x2 + x3 + 9 * x4 <= 310)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"x1: {x1.varValue}")
        print(f"x2: {x2.varValue}")
        print(f"x3: {x3.varValue}")
        print(f"x4: {x4.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize_problem()
