
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("vitamin_optimization")

    # Create variables
    x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_B1")
    x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="vitamin_B2")
    x2 = m.addVar(lb=0, vtype=gp.GRB.INTEGER, name="vitamin_E")

    # Set objective function
    m.setObjective(3.28 * x0 + 1.23 * x1 + 9.04 * x2, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(11 * x0 + 7 * x2 >= 20, "c1")
    m.addConstr(11 * x0 + 2 * x1 + 7 * x2 >= 20, "c2")
    m.addConstr(11 * x0 + 8 * x2 >= 28, "c3")
    m.addConstr(5 * x1 + 8 * x2 >= 24, "c4")
    m.addConstr(11 * x0 + 5 * x1 + 8 * x2 >= 24, "c5")
    m.addConstr(2 * x0 - 7 * x1 >= 0, "c6")
    m.addConstr(-7 * x1 + 2 * x2 >= 0, "c7")
    m.addConstr(11 * x0 + 5 * x1 <= 76, "c8")
    m.addConstr(5 * x1 + 8 * x2 <= 65, "c9")

    # Resource constraints
    m.addConstr(11 * x0 + 2 * x1 + 7 * x2 <= 126, "r0")
    m.addConstr(11 * x0 + 5 * x1 + 8 * x2 <= 142, "r1")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('vitamin_B1:', x0.x)
        print('vitamin_B2:', x1.x)
        print('vitamin_E:', x2.x)

    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
