
import gurobi as gp

# Define the model
model = gp.Model("vitamin_problem")

# Define the variables
x0 = model.addVar(name="x0", lb=0)  # milligrams of vitamin B1
x1 = model.addVar(name="x1", lb=0)  # milligrams of vitamin B2
x2 = model.addVar(name="x2", lb=0, type=gp.GRB.INTEGER)  # milligrams of vitamin E

# Objective function
model.setObjective(3.28*x0 + 1.23*x1 + 9.04*x2, gp.GRB.MINIMIZE)

# Constraints
model.addConstr(11*x0 <= 126)
model.addConstr(11*x0 <= 142)
model.addConstr(2*x1 <= 126)
model.addConstr(5*x1 <= 142)
model.addConstr(7*x2 <= 126)
model.addConstr(8*x2 <= 142)
model.addConstr(11*x0 + 7*x2 >= 20)
model.addConstr(11*x0 + 2*x1 + 7*x2 >= 20)
model.addConstr(11*x0 + 8*x2 >= 28)
model.addConstr(5*x1 + 8*x2 >= 24)
model.addConstr(11*x0 + 5*x1 + 8*x2 >= 24)
model.addConstr(2*x0 - 7*x1 >= 0)
model.addConstr(-7*x1 + 2*x2 >= 0)
model.addConstr(11*x0 + 5*x1 <= 76)
model.addConstr(5*x1 + 8*x2 <= 65)

# Solve the model
model.optimize()

# Print the solution
if model.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"x0: {x0.varValue}")
    print(f"x1: {x1.varValue}")
    print(f"x2: {x2.varValue}")
    print(f"Objective: {model.objVal}")
else:
    print("No optimal solution found.")
