
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("food_optimization")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.INTEGER, name="chicken_drumsticks")
    x1 = m.addVar(vtype=gp.GRB.INTEGER, name="chicken_thighs")


    # Set objective function
    m.setObjective(5.19*x0**2 + 1.48*x0*x1 + 2.41*x1**2 + 1.82*x0 + 9.63*x1, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(3*x0 + 8*x1 >= 53, "c0")
    m.addConstr(11*x0**2 + 6*x1**2 >= 24, "c1")
    m.addConstr(2*x0**2 + 6*x1**2 >= 35, "c2")
    m.addConstr(9*x0 + 7*x1 >= 27, "c3")
    m.addConstr(11*x0 + 6*x1 >= 14, "c4")
    m.addConstr(8*x0**2 - 5*x1**2 >= 0, "c5")
    m.addConstr(3*x0 + 8*x1 <= 108, "c6")
    m.addConstr(11*x0 + 6*x1 <= 73, "c7")
    m.addConstr(2*x0 + 6*x1 <= 84, "c8")
    m.addConstr(9*x0 + 7*x1 <= 85, "c9")
    m.addConstr(11*x0 + 6*x1 <= 47, "c10")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("Optimization ended with status:", m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
