
import gurobi

def solve_optimization_problem():
    model = gurobi.Model()
    
    # Define variables
    x1 = model.addVar(name="chicken_drumsticks", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="chicken_thighs", vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(5.19*x1**2 + 1.48*x1*x2 + 2.41*x2**2 + 1.82*x1 + 9.63*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(3*x1 + 8*x2 >= 53)
    model.addConstr(121*x1**2 + 36*x2**2 >= 24)
    model.addConstr(4*x1**2 + 36*x2**2 >= 35)
    model.addConstr(9*x1 + 7*x2 >= 27)
    model.addConstr(11*x1 + 6*x2 >= 14)
    model.addConstr(8*x1**2 - 5*x2**2 >= 0)
    model.addConstr(3*x1 + 8*x2 <= 108)
    model.addConstr(11*x1 + 6*x2 <= 73)
    model.addConstr(2*x1 + 6*x2 <= 84)
    model.addConstr(9*x1 + 7*x2 <= 85)
    model.addConstr(11*x1 + 6*x2 <= 72)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("Chicken drumsticks: ", x1.varValue)
        print("Chicken thighs: ", x2.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
