
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="rotisserie_chickens")
    x1 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="potatoes")
    x2 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="strips_of_bacon")


    # Set objective function
    m.setObjective(8*x0 + 1*x1 + 5*x2, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(21*x0 + 26*x1 >= 27)
    m.addConstr(27*x0 + 25*x2 >= 57)
    m.addConstr(24*x1 + 25*x2 >= 102)
    m.addConstr(27*x0 + 24*x1 + 25*x2 >= 58)
    m.addConstr(32*x0 + 14*x1 + 18*x2 >= 124)
    m.addConstr(21*x0 + 26*x1 <= 131)
    m.addConstr(26*x1 + 27*x2 <= 142)
    m.addConstr(21*x0 + 26*x1 + 27*x2 <= 142)
    m.addConstr(24*x1 + 25*x2 <= 279)
    m.addConstr(27*x0 + 24*x1 + 25*x2 <= 279)
    m.addConstr(32*x0 + 18*x2 <= 350)
    m.addConstr(14*x1 + 18*x2 <= 460)
    m.addConstr(32*x0 + 14*x1 + 18*x2 <= 460)
    m.addConstr(27*x0 + 25*x1 <= 212)
    m.addConstr(27*x0 + 1*x2 <= 143)
    m.addConstr(27*x0 + 25*x1 + 1*x2 <= 174)
    m.addConstr(9*x0 + 26*x2 <= 345)
    m.addConstr(9*x0 + 31*x1 <= 365)
    m.addConstr(31*x1 + 26*x2 <= 373)
    m.addConstr(9*x0 + 31*x1 + 26*x2 <= 314)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print("The problem is infeasible.")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
