
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name='x1', lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
    x2 = model.addVar(name='x2', lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
    x3 = model.addVar(name='x3', lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)

    # Define the objective function
    model.setObjective(8 * x1 + x2 + 5 * x3, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(21 * x1 + 26 * x2 >= 27)
    model.addConstr(27 * x1 + 24 * x2 + 25 * x3 >= 57)
    model.addConstr(24 * x2 + 25 * x3 >= 102)
    model.addConstr(27 * x1 + 24 * x2 + 25 * x3 >= 58)
    model.addConstr(32 * x1 + 14 * x2 + 18 * x3 >= 124)
    model.addConstr(21 * x1 + 26 * x2 <= 131)
    model.addConstr(26 * x2 + 27 * x3 <= 142)
    model.addConstr(21 * x1 + 26 * x2 + 27 * x3 <= 142)
    model.addConstr(24 * x2 + 25 * x3 <= 279)
    model.addConstr(27 * x1 + 24 * x2 + 25 * x3 <= 279)
    model.addConstr(32 * x1 + 18 * x3 <= 350)
    model.addConstr(14 * x2 + 18 * x3 <= 460)
    model.addConstr(32 * x1 + 14 * x2 + 18 * x3 <= 460)
    model.addConstr(27 * x1 + 25 * x2 <= 212)
    model.addConstr(27 * x1 + x3 <= 143)
    model.addConstr(27 * x1 + 25 * x2 + x3 <= 174)
    model.addConstr(9 * x1 + 26 * x3 <= 345)
    model.addConstr(9 * x1 + 31 * x2 <= 365)
    model.addConstr(31 * x2 + 26 * x3 <= 373)
    model.addConstr(9 * x1 + 31 * x2 + 26 * x3 <= 314)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Objective: ', model.objval)
        print('x1: ', x1.x)
        print('x2: ', x2.x)
        print('x3: ', x3.x)
    else:
        print('The model is infeasible')

solve_optimization_problem()
